/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.utils;

import com.fasterxml.jackson.dataformat.yaml.snakeyaml.Yaml;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private Map<Object, Object> configurations = new Hashtable<Object, Object>();
    private String confFileName = "conf/vistara.yml";
    private static Configuration _instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() throws Exception {
        if (_instance != null) return _instance;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (_instance != null) return _instance;
            _instance = new Configuration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private Configuration() throws Exception {
        this.loadConfigurations(this.confFileName);
    }

    private void loadConfigurations(String ConfigurationFileName) throws Exception {
        try {
            Yaml yaml = new Yaml();
            this.logger.info("------------------------- ---- -- Loading config properties from the file :" + ConfigurationFileName);
            this.configurations = (Map)yaml.load(new FileInputStream(ConfigurationFileName));
        }
        catch (Exception e) {
            this.logger.error("Exception in loading config properties :" + e.getMessage());
            throw e;
        }
    }

    public String getConfiguration(String configurationType, String propertyKey) throws Exception {
        Map configs = (Map)this.configurations.get(configurationType);
        if (null != configs && null != configs.get(propertyKey)) {
            return (String)configs.get(propertyKey);
        }
        return null;
    }
}

