/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vistara.sdk.dto.Results;
import com.vistara.sdk.dto.device.Device;
import com.vistara.sdk.dto.device.DeviceType;
import com.vistara.sdk.dto.device.IndexedResource;
import com.vistara.sdk.dto.metric.MonitoringTemplate;
import com.vistara.sdk.dto.response.Response;
import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.APITemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResourceAPI
implements APIConstants {
    private static Logger logger = LoggerFactory.getLogger(SearchResourceAPI.class);
    static String OK = "200";

    public static Results<IndexedResource> getDeviceData(String clientId, String devType, int pageNo, int pageSize) throws Exception {
        String URI2 = SearchResourceAPI.getDeviceByTypeURI(clientId, devType, pageNo, pageSize);
        try {
            Response res;
            String jsonData = APITemplate.getInstance(clientId).getRequest(URI2);
            if (jsonData != null && (res = (Response)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Response>(){})) != null && res.getStatus().equals(OK) && res.getStatus_message() != null) {
                return (Results)new ObjectMapper().readValue(res.getStatus_message(), (TypeReference)new TypeReference<Results<IndexedResource>>(){});
            }
        }
        catch (Exception e) {
            logger.error("@ Fetching Resource data for URI:" + URI2);
            throw e;
        }
        return null;
    }

    public static List<IndexedResource> getDevices(String clientId, String devType) throws Exception {
        ArrayList<IndexedResource> devices = new ArrayList<IndexedResource>();
        int pageNo = 1;
        int pageSize = 100;
        Results<IndexedResource> results = null;
        do {
            if ((results = SearchResourceAPI.getDeviceData(clientId, devType, pageNo, pageSize)) == null || results.getResults() == null || results.getResults().isEmpty()) continue;
            devices.addAll(results.getResults());
        } while ((pageNo = results != null && results.isNextPage() ? results.getNextPageNo() : 0) > 0);
        return devices;
    }

    private static String getDeviceByTypeURI(String clientId, String devType, int pageNo, int pageSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("tenants/");
        sb.append(clientId + "/");
        sb.append("resources/");
        sb.append("search?");
        sb.append("pageNo=").append(pageNo);
        sb.append("&pageSize=").append(pageSize);
        if (devType != null) {
            sb.append("&queryString=deviceType:" + devType);
        }
        return sb.toString();
    }

    public static Device getDevice(String clientId, String devId) throws Exception {
        String URI2 = SearchResourceAPI.getDeviceURI(clientId, devId);
        try {
            Response res;
            String jsonData = APITemplate.getInstance(clientId).getRequest(URI2);
            if (jsonData != null && (res = (Response)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Response>(){})) != null && res.getStatus().equals(OK) && res.getStatus_message() != null) {
                return (Device)new ObjectMapper().readValue(res.getStatus_message(), (TypeReference)new TypeReference<Device>(){});
            }
        }
        catch (Exception e) {
            logger.error(URI2);
            logger.error(e.getMessage(), e);
        }
        return null;
    }

    private static String getDeviceURI(String clientId, String devId) {
        StringBuilder sb = new StringBuilder();
        sb.append("tenants/");
        sb.append(clientId + "/");
        sb.append("devices/");
        sb.append(devId);
        return sb.toString();
    }

    private static String getAvailabilityAPI(String clientId, String serviceUUID, String sourceType, long startTS, long endTS) {
        StringBuffer sb = new StringBuffer();
        sb.append("/tenants/");
        sb.append(clientId).append("/");
        sb.append("rtypes").append("/").append(sourceType).append("/");
        sb.append("resources").append("/").append(serviceUUID).append("/");
        sb.append("availability").append("?");
        sb.append("startTime=").append(startTS);
        sb.append("&endTime=").append(endTS);
        sb.append("&rca=true");
        return sb.toString();
    }

    public static Map<String, Object> getAvailability(String clientId, String serviceUUID, String sourceType, long startTS, long endTS) throws Exception {
        String uri = SearchResourceAPI.getAvailabilityAPI(clientId, serviceUUID, sourceType, startTS, endTS);
        String jsonData = null;
        Response res = null;
        int retryCNT = 0;
        do {
            try {
                jsonData = APITemplate.getInstance(clientId).getRequest(uri);
                if (jsonData != null && (res = (Response)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Response>(){})) != null && res.getStatus().equals(OK) && res.getStatus_message() != null) {
                    return (Map)new ObjectMapper().readValue(res.getStatus_message(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                }
                ++retryCNT;
            }
            catch (Exception e) {
                logger.error("@ Fetching availability data:" + uri);
                logger.error("", e);
            }
        } while ((jsonData == null || res.getStatus().equals("504")) && retryCNT < 5);
        return null;
    }

    public static Results<MonitoringTemplate> getTemplateData(String cUid, String devId, int pageNo, int pageSize) throws Exception {
        String uri = SearchResourceAPI.getTemplatesAPI(cUid, devId, pageNo, pageSize);
        String jsonData = APITemplate.getInstance(cUid).getRequest(uri);
        if (jsonData != null) {
            try {
                Response res = (Response)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Response>(){});
                if (res != null && res.getStatus().equals(OK) && res.getStatus_message() != null) {
                    return (Results)new ObjectMapper().readValue(res.getStatus_message(), (TypeReference)new TypeReference<Results<MonitoringTemplate>>(){});
                }
            }
            catch (Exception e) {
                logger.error(uri);
                logger.error(e.getMessage(), e);
            }
        }
        return null;
    }

    public static List<MonitoringTemplate> getTemplates(String clientId, String devId) throws Exception {
        ArrayList<MonitoringTemplate> templates = new ArrayList<MonitoringTemplate>();
        int pageNo = 1;
        int pageSize = 100;
        Results<MonitoringTemplate> results = null;
        do {
            if ((results = SearchResourceAPI.getTemplateData(clientId, devId, pageNo, pageSize)) == null || results.getResults() == null || results.getResults().size() <= 0) continue;
            templates.addAll(results.getResults());
        } while ((pageNo = results != null && results.isNextPage() ? results.getNextPageNo() : 0) > 0);
        return templates;
    }

    private static String getTemplatesAPI(String cUId, String devId, int pageNo, int pageSize) {
        StringBuffer sb = new StringBuffer("tenants/");
        sb.append(cUId);
        sb.append("/resources/");
        sb.append(devId).append("/templates/search?");
        sb.append("pageNo=").append(pageNo);
        sb.append("&pageSize=").append(pageSize);
        return sb.toString();
    }

    public static List<DeviceType> getDeviceTypes(String cUid) throws Exception {
        String uri = "/tenants/" + cUid + "/resourceType/minimal";
        String jsonData = APITemplate.getInstance(cUid).getRequest(uri);
        if (jsonData != null) {
            try {
                Response res = (Response)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Response>(){});
                if (res != null && res.getStatus().equals(OK) && res.getStatus_message() != null) {
                    return (List)new ObjectMapper().readValue(res.getStatus_message(), (TypeReference)new TypeReference<List<DeviceType>>(){});
                }
            }
            catch (Exception e) {
                logger.error(uri);
                logger.error(e.getMessage(), e);
            }
        }
        return new ArrayList<DeviceType>();
    }
}

